/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.pipe.attachment.extractor;

import com.refinedmods.refinedpipes.block.FluidPipeBlock;
import com.refinedmods.refinedpipes.block.ItemPipeBlock;
import com.refinedmods.refinedpipes.network.pipe.Pipe;
import com.refinedmods.refinedpipes.network.pipe.attachment.Attachment;
import com.refinedmods.refinedpipes.network.pipe.attachment.AttachmentFactory;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.BlacklistWhitelist;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.ExtractorAttachment;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.ExtractorAttachmentType;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.RedstoneMode;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.RoutingMode;
import com.refinedmods.refinedpipes.util.DirectionUtil;
import com.refinedmods.refinedpipes.util.StringUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class ExtractorAttachmentFactory
implements AttachmentFactory {
    private final ExtractorAttachmentType type;

    public ExtractorAttachmentFactory(ExtractorAttachmentType type) {
        this.type = type;
    }

    @Override
    public Attachment createFromNbt(Pipe pipe, CompoundTag tag) {
        Direction dir = DirectionUtil.safeGet((byte)tag.m_128451_("dir"));
        ExtractorAttachment attachment = new ExtractorAttachment(pipe, dir, this.type);
        if (tag.m_128441_("itemfilter")) {
            attachment.getItemFilter().deserializeNBT(tag.m_128469_("itemfilter"));
        }
        if (tag.m_128441_("rm")) {
            attachment.setRedstoneMode(RedstoneMode.get(tag.m_128445_("rm")));
        }
        if (tag.m_128441_("bw")) {
            attachment.setBlacklistWhitelist(BlacklistWhitelist.get(tag.m_128445_("bw")));
        }
        if (tag.m_128441_("rr")) {
            attachment.setRoundRobinIndex(tag.m_128451_("rr"));
        }
        if (tag.m_128441_("routingm")) {
            attachment.setRoutingMode(RoutingMode.get(tag.m_128445_("routingm")));
        }
        if (tag.m_128441_("stacksi")) {
            attachment.setStackSize(tag.m_128451_("stacksi"));
        }
        if (tag.m_128441_("exa")) {
            attachment.setExactMode(tag.m_128471_("exa"));
        }
        if (tag.m_128441_("fluidfilter")) {
            attachment.getFluidFilter().readFromNbt(tag.m_128469_("fluidfilter"));
        }
        return attachment;
    }

    @Override
    public Attachment create(Pipe pipe, Direction dir) {
        return new ExtractorAttachment(pipe, dir, this.type);
    }

    @Override
    public ResourceLocation getItemId() {
        return this.type.getItemId();
    }

    @Override
    public ResourceLocation getId() {
        return this.type.getId();
    }

    @Override
    public ResourceLocation getModelLocation() {
        return this.type.getModelLocation();
    }

    @Override
    public void addInformation(List<Component> tooltip) {
        tooltip.add((Component)new TranslatableComponent("misc.refinedpipes.tier", new Object[]{new TranslatableComponent("enchantment.level." + this.type.getTier())}).m_130940_(ChatFormatting.YELLOW));
        MutableComponent itemsToExtract = new TextComponent(StringUtil.formatNumber(this.type.getItemsToExtract()) + " ").m_7220_((Component)new TranslatableComponent("misc.refinedpipes.item" + (this.type.getItemsToExtract() == 1 ? "" : "s"))).m_130940_(ChatFormatting.WHITE);
        float itemSecondsInterval = (float)this.type.getItemTickInterval() / 20.0f;
        MutableComponent itemTickInterval = new TextComponent(StringUtil.formatNumber(itemSecondsInterval) + " ").m_7220_((Component)new TranslatableComponent("misc.refinedpipes.second" + (itemSecondsInterval == 1.0f ? "" : "s"))).m_130940_(ChatFormatting.WHITE);
        tooltip.add((Component)new TranslatableComponent("tooltip.refinedpipes.extractor_attachment.item_extraction_rate", new Object[]{itemsToExtract, itemTickInterval}).m_130940_(ChatFormatting.GRAY));
        MutableComponent fluidsToExtract = new TextComponent(StringUtil.formatNumber(this.type.getFluidsToExtract()) + " mB").m_130940_(ChatFormatting.WHITE);
        float fluidSecondsInterval = (float)this.type.getFluidTickInterval() / 20.0f;
        MutableComponent fluidTickInterval = new TextComponent(StringUtil.formatNumber(fluidSecondsInterval) + " ").m_7220_((Component)new TranslatableComponent("misc.refinedpipes.second" + (fluidSecondsInterval == 1.0f ? "" : "s"))).m_130940_(ChatFormatting.WHITE);
        tooltip.add((Component)new TranslatableComponent("tooltip.refinedpipes.extractor_attachment.fluid_extraction_rate", new Object[]{fluidsToExtract, fluidTickInterval}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)new TranslatableComponent("tooltip.refinedpipes.extractor_attachment.filter_slots", new Object[]{new TextComponent("" + this.type.getFilterSlots()).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GRAY));
        this.addAbilityToInformation(tooltip, this.type.getCanSetRedstoneMode(), "misc.refinedpipes.redstone_mode");
        this.addAbilityToInformation(tooltip, this.type.getCanSetWhitelistBlacklist(), "misc.refinedpipes.mode");
        this.addAbilityToInformation(tooltip, this.type.getCanSetRoutingMode(), "misc.refinedpipes.routing_mode");
        this.addAbilityToInformation(tooltip, this.type.getCanSetExactMode(), "misc.refinedpipes.exact_mode");
    }

    private void addAbilityToInformation(List<Component> tooltip, boolean possible, String key) {
        tooltip.add((Component)new TextComponent(possible ? "\u2713 " : "\u274c ").m_7220_((Component)new TranslatableComponent(key)).m_130940_(possible ? ChatFormatting.GREEN : ChatFormatting.RED));
    }

    @Override
    public boolean canPlaceOnPipe(Block pipe) {
        return pipe instanceof ItemPipeBlock || pipe instanceof FluidPipeBlock;
    }
}

